//adapted from Original http://glslsandbox.com/e#72103.0
//as 'Sandbox hexvortex.fsh'
// Licence CC0
// Adapted, trivialy, for use in VGHD player by ET.

uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.
// -----------------------------------------------------------------------------
//#define iGlobalTime   u_Elapsed 
//#define time u_Elapsed
//#define texture2D texture2D_Fract
#define time u_Elapsed* 0.333
//#define iResolution     u_WindowSize
//#define resolution      iResolution
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

// file:  Sandbox hexvortex.glsl
// from http://glslsandbox.com/e#72103.0

// "Sandbox hexvortwx" by unknown
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

#ifdef GL_ES
precision mediump float;
#endif
//uniform float time;
//uniform vec2 mouse;
//uniform vec2 resolution;

#define FC gl_FragCoord
#define o gl_FragColor
#define r resolution
#define t time

#define rotate2D(a) mat2(cos(a),-sin(a),sin(a),cos(a))

void main( void ) {
	vec2 p;
	float i,g,d=1.;
	for(float j=0.;j<128.;j++) {
		++i;
		if (d<=.001) break;
		p=vec2((FC.xy-.5*r)/r.y)*g+vec2(.3)*rotate2D(g*2.);
		g+=d=-(length(p)-2.+g/9.)/2.;
	}
	gl_FragColor.a = length(gl_FragColor.rgb); // makes black transparent
	p=vec2(atan(p.x,p.y),g)*8.28+t*2.;
	p=abs(fract(p+vec2(0,.5*ceil(p.x)))-.5);
	o+=30./i-.5/step(.9,1.-abs(max(p.x*1.5+p.y,p.y*2.)-1.));

}
